  /*
   *  Object %name    : parser_atp_sst_index.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_sst_index.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/
#include "SST_SEP_ATP_Index.h"
#include "parser_atp_sst_index.h"
#include "sep_utils.h"
#include "stdio.h"
/************************ Global Data ************************/
    extern DxByte_t*               TST_Workspace;
    extern DxUint32_t              TST_WorkspaceSizeInBytes ;
    extern DxUint8_t*              GlobalMemBuff;
    extern DxUint8_t*              CurrGlobalMemBuff;
    TST_ATP_IndexTestDataStruct*   TST_ATP_IndexTestData;
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpAES
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_SST_Index finction.
* It calls the SEP function with parameters parsed from input message
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_Index(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_IndexTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_IndexTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_IndexTestData = (TST_ATP_IndexTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_IndexTestDataStruct);
    }

     /* 4. extract parameters from the message */
     /******************************************/
     DX_VOS_FastMemCpy(&TST_ATP_IndexTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_IndexTestDataStruct));

      /* 5. call QA SEP function */
     /***************************/
      SEP_Error = SEPQA_SST_Index();
      SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_Index");

End:
     /* 6. Free allocated buffers */
    DX_VOS_MemFree(GlobalMemBuff);

     /* 7. end SEP message and return */
     /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_Index_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}
